/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.burned;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.level.entities.frostbitten.Frostbitten;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.core.RottenCreatures;
import com.github.teamfusion.rottencreatures.core.data.loot.RCLootTables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Burned
extends Zombie {
    private static final AttributeModifier CRAZY_MODIFIER = new AttributeModifier(RottenCreatures.resource("crazy_attribute_boost"), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier OBSIDIAN_MODIFIER = new AttributeModifier(RottenCreatures.resource("obsidian_attribute_boost"), 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final EntityDataAccessor<Boolean> DATA_IS_OBSIDIAN = SynchedEntityData.defineId(Burned.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_CRAZY = SynchedEntityData.defineId(Burned.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Burned(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
        this.xpReward = 5;
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
    }

    protected void addBehaviourGoals() {
        super.addBehaviourGoals();
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Frostbitten.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.createAttributes().add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0).add(Attributes.MAX_HEALTH, 22.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_OBSIDIAN, (Object)false);
        builder.define(DATA_IS_CRAZY, (Object)false);
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return this.isObsidian() ? RCLootTables.BURNED_OBSIDIAN : super.getDefaultLootTable();
    }

    protected boolean convertsInWater() {
        return false;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if ((double)this.getHealth() <= (double)this.getMaxHealth() * 0.5 && !this.isCrazy()) {
            this.setCrazy(true);
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.random.nextInt(10) == 0) {
            this.level().addParticle((ParticleOptions)(this.isObsidian() ? ParticleTypes.FALLING_OBSIDIAN_TEAR : ParticleTypes.FALLING_LAVA), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
        if (this.isCrazy() && this.random.nextInt(10) == 0) {
            this.level().addParticle((ParticleOptions)(this.isObsidian() ? (this.random.nextBoolean() ? ParticleTypes.SMOKE : ParticleTypes.LARGE_SMOKE) : ParticleTypes.LAVA), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
    }

    public void tick() {
        if (this.isAlive()) {
            if (this.isInWaterOrBubble() && !this.isObsidian()) {
                this.setObsidian(true);
            }
            if (this.isInLava() && this.isObsidian()) {
                this.setObsidian(false);
            }
        }
        super.tick();
    }

    protected SoundEvent getAmbientSound() {
        return RCSoundEvents.BURNED_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return RCSoundEvents.BURNED_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return RCSoundEvents.BURNED_DEATH.get();
    }

    public boolean doHurtTarget(Entity entity) {
        boolean hurt = super.doHurtTarget(entity);
        if (hurt && this.getMainHandItem().isEmpty() && !this.isObsidian() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float modifier = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            living.igniteForSeconds((float)(3 * (int)modifier));
        }
        return hurt;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isObsidian() && source.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean isSensitiveToWater() {
        return !this.isObsidian() && !this.isInWaterOrBubble();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("IsObsidian", this.isObsidian());
        tag.putBoolean("IsCrazy", this.isCrazy());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setObsidian(tag.getBoolean("IsObsidian"));
        this.setCrazy(tag.getBoolean("IsCrazy"));
    }

    public boolean isObsidian() {
        return (Boolean)this.getEntityData().get(DATA_IS_OBSIDIAN);
    }

    public void setObsidian(boolean obsidian) {
        this.getEntityData().set(DATA_IS_OBSIDIAN, (Object)obsidian);
        if (!this.level().isClientSide) {
            AttributeInstance attackDamage = this.getAttribute(Attributes.ATTACK_DAMAGE);
            AttributeInstance knockbackResistance = this.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
            if (attackDamage != null && knockbackResistance != null) {
                attackDamage.removeModifier(OBSIDIAN_MODIFIER);
                knockbackResistance.removeModifier(OBSIDIAN_MODIFIER);
                if (obsidian) {
                    attackDamage.addTransientModifier(OBSIDIAN_MODIFIER);
                    knockbackResistance.addTransientModifier(OBSIDIAN_MODIFIER);
                }
            }
        }
        if (obsidian) {
            this.level().levelEvent(1501, this.blockPosition(), 0);
        }
    }

    public boolean isCrazy() {
        return (Boolean)this.getEntityData().get(DATA_IS_CRAZY);
    }

    public void setCrazy(boolean crazy) {
        this.getEntityData().set(DATA_IS_CRAZY, (Object)crazy);
        if (!this.level().isClientSide) {
            AttributeInstance attackDamage = this.getAttribute(Attributes.ATTACK_DAMAGE);
            AttributeInstance knockbackResistance = this.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
            if (attackDamage != null && knockbackResistance != null) {
                attackDamage.removeModifier(CRAZY_MODIFIER);
                knockbackResistance.removeModifier(CRAZY_MODIFIER);
                if (crazy) {
                    attackDamage.addTransientModifier(CRAZY_MODIFIER);
                    knockbackResistance.addTransientModifier(CRAZY_MODIFIER);
                }
            }
        }
    }

    public void travel(Vec3 vector) {
        this.setSpeed(this.getMoveSpeed());
        super.travel(vector);
    }

    public float getMoveSpeed() {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (this.isObsidian() ? 0.5f : (this.isCrazy() ? 1.5f : 1.0f));
    }

    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)RCBlocks.BURNED_HEAD.get());
    }

    protected int calculateFallDamage(float distance, float amount) {
        return super.calculateFallDamage(distance, amount) - (this.isObsidian() ? 10 : 0);
    }

    public static boolean checkBurnedSpawnRules(EntityType<Burned> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return !level.getBlockState(pos.below()).is(Blocks.NETHER_WART_BLOCK);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        if (this.random.nextFloat() <= 0.05f) {
            this.setCrazy(true);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, groupData);
    }
}

